<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

include "konfigurasi/koneksi.php";

if (!isset($connect) && isset($koneksi)) { $connect = $koneksi; }

// 1. TANGKAP PARAMETER (Bisa ID Mitra atau ID User Investor)
$id_mitra = isset($_GET['id_mitra']) ? mysqli_real_escape_string($connect, $_GET['id_mitra']) : '';
$id_user  = isset($_GET['id_user']) ? mysqli_real_escape_string($connect, $_GET['id_user']) : '';

// 2. QUERY DASAR
$sql = "SELECT p.*, o.judul as nama_proyek, u.nama_lengkap, u.email, u.no_hp 
        FROM permintaan_investasi p 
        JOIN peluang_investasi o ON p.id_peluang = o.id 
        JOIN users u ON p.id_user = u.id 
        WHERE p.status = 'Diterima'";

// 3. LOGIKA FILTER

// A. Jika MITRA yang login: Tampilkan investor di proyek miliknya
if (!empty($id_mitra)) {
    $sql .= " AND o.id_mitra = '$id_mitra'";
}

// B. Jika INVESTOR yang login: Tampilkan investor HANYA di proyek yang dia ikuti
if (!empty($id_user)) {
    // Subquery: Cari ID Peluang dimana User ini juga bergabung dengan status Diterima
    $sql .= " AND p.id_peluang IN (
                SELECT sub.id_peluang 
                FROM permintaan_investasi sub 
                WHERE sub.id_user = '$id_user' 
                AND sub.status = 'Diterima'
              )";
}

// 4. URUTKAN DATA
$sql .= " ORDER BY p.tanggal DESC";

$result = $connect->query($sql);
$data = array();

while($row = $result->fetch_assoc()) {
    $data[] = $row;
}

echo json_encode($data);
$connect->close();
?>