<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include "konfigurasi/koneksi.php";

// Menangkap id_user dari parameter URL (misal: get_portfolio.php?id_user=8)
$id_user = isset($_GET['id_user']) ? mysqli_real_escape_string($connect, $_GET['id_user']) : null;

if (empty($id_user)) {
    echo json_encode(["status" => "error", "message" => "ID User tidak disertakan"]);
    exit();
}

// Query untuk mengambil data portofolio berdasarkan id_user
$sql = "SELECT id, file_name, file_path, file_type, description, uploaded_at 
        FROM portfolio 
        WHERE id_user = '$id_user' 
        ORDER BY uploaded_at DESC";

$result = mysqli_query($connect, $sql);

if ($result) {
    $portfolios = [];
    while ($row = mysqli_fetch_assoc($result)) {
        // Menambahkan URL lengkap agar file bisa diakses/didownload oleh Flutter
        $row['full_url'] = "https://laferacollective.web.id/lafera_api/" . $row['file_path'];
        $portfolios[] = $row;
    }

    echo json_encode([
        "status" => "success",
        "data" => $portfolios
    ]);
} else {
    echo json_encode([
        "status" => "error", 
        "message" => "Gagal mengambil data: " . mysqli_error($connect)
    ]);
}

mysqli_close($connect);
?>