<?php
// lafera_api/konfigurasi/fcm_helper.php

function getGoogleAccessToken($keyFile) {
    if (!file_exists($keyFile)) { return false; }
    
    $data = json_decode(file_get_contents($keyFile), true);
    $now = time();
    
    $header = json_encode(['alg' => 'RS256', 'typ' => 'JWT']);
    $payload = json_encode([
        'iss' => $data['client_email'],
        'scope' => 'https://www.googleapis.com/auth/firebase.messaging',
        'aud' => 'https://oauth2.googleapis.com/token',
        'exp' => $now + 3600,
        'iat' => $now
    ]);
    
    $base64UrlHeader = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($header));
    $base64UrlPayload = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($payload));
    
    $signatureInput = $base64UrlHeader . "." . $base64UrlPayload;
    $signature = '';
    openssl_sign($signatureInput, $signature, $data['private_key'], 'SHA256');
    $base64UrlSignature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($signature));
    
    $jwt = $signatureInput . "." . $base64UrlSignature;
    
    // Request Access Token
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://oauth2.googleapis.com/token');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
        'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
        'assertion' => $jwt
    ]));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
    
    $json = json_decode($response, true);
    return $json['access_token'] ?? false;
}

function kirimNotifikasiFCM($token, $judul, $pesan) {
    // Pastikan file JSON ada di folder yang sama
    $keyFile = __DIR__ . '/service-account.json'; 
    $accessToken = getGoogleAccessToken($keyFile);
    
    if (!$accessToken) { return "Error: Gagal ambil token"; }

    // Ambil Project ID dari JSON
    $jsonKey = json_decode(file_get_contents($keyFile), true);
    $projectId = $jsonKey['project_id'];

    $url = "https://fcm.googleapis.com/v1/projects/$projectId/messages:send";
    
    $data = [
        'message' => [
            'token' => $token,
            'notification' => [
                'title' => $judul,
                'body'  => $pesan
            ]
        ]
    ];

    $headers = [
        'Authorization: Bearer ' . $accessToken,
        'Content-Type: application/json'
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    
    $result = curl_exec($ch);
    curl_close($ch);
    
    return $result;
}
?>