<?php
// lafera_api/peluang_investasi.php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

// Menggunakan koneksi mysqli sesuai style kode asli Anda
$conn = new mysqli("localhost", "root", "", "db_lafera");

// --- 1. TAMBAHAN WAJIB: Panggil Helper FCM ---
include "konfigurasi/fcm_helper.php"; 
// ---------------------------------------------

if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

$method = $_SERVER['REQUEST_METHOD'];

switch($method) {
    case 'GET':
        $id_mitra = isset($_GET['id_mitra']) ? $_GET['id_mitra'] : '';
        $role = isset($_GET['role']) ? $_GET['role'] : '';

        if (!empty($id_mitra)) {
            $sql = "SELECT * FROM peluang_investasi WHERE id_mitra = '$id_mitra' ORDER BY id DESC";
        } else {
            if ($role == 'investor') {
                $sql = "SELECT p.*, m.nama_toko, m.alamat, m.foto_logo 
                        FROM peluang_investasi p 
                        LEFT JOIN mitra_profil m ON p.id_mitra = m.id 
                        ORDER BY p.id DESC";
            } else {
                $sql = "SELECT * FROM peluang_investasi ORDER BY id DESC";
            }
        }

        $result = $conn->query($sql);
        $data = array();
        
        if ($result) {
            while($row = $result->fetch_assoc()) {
                
                // --- UPDATE: AMBIL DATA LAPORAN OUTLET KHUSUS UNTUK INVESTOR ---
                // Ini bertujuan untuk menarik kepercayaan investor dengan melihat performa mitra
                if ($role == 'investor') {
                    $id_m = $row['id_mitra'];
                    // Mengambil 4 kuartal terakhir milik mitra tersebut
                    $q_laporan = $conn->query("SELECT * FROM laporan_outlet 
                                               WHERE id_mitra = '$id_m' 
                                               ORDER BY tahun DESC, 
                                               FIELD(bulan, 'Kuartal 4', 'Kuartal 3', 'Kuartal 2', 'Kuartal 1') DESC 
                                               LIMIT 4");
                    
                    $laporan_performa = array();
                    if ($q_laporan) {
                        while($lap = $q_laporan->fetch_assoc()) {
                            $laporan_performa[] = $lap;
                        }
                    }
                    // Kita balik urutannya (array_reverse) agar di grafik Flutter tampil dari waktu lama ke baru
                    $row['laporan_performa'] = array_reverse($laporan_performa);
                }
                // ---------------------------------------------------------------

                $data[] = $row;
            }
        }
        echo json_encode($data);
        break;

    case 'POST':
        // 1. TANGKAP DATA INPUT
        $judul = $_POST['judul'];
        $deskripsi = $_POST['deskripsi'];
        $target = $_POST['target_dana'];
        $bagi_hasil = $_POST['prosentase_bagi_hasil'];
        $terkumpul = isset($_POST['dana_terkumpul']) ? $_POST['dana_terkumpul'] : 0;
        $id_mitra = isset($_POST['id_mitra']) && $_POST['id_mitra'] != '' ? $_POST['id_mitra'] : 1;
        
        // 2. INSERT KE PELUANG INVESTASI
        $sql = "INSERT INTO peluang_investasi (judul, deskripsi, target_dana, dana_terkumpul, prosentase_bagi_hasil, id_mitra) 
                VALUES ('$judul', '$deskripsi', '$target', '$terkumpul', '$bagi_hasil', '$id_mitra')";
        
        if($conn->query($sql)) {
            
            // --- MULAI LOGIKA NOTIFIKASI OTOMATIS ---
            
            // A. Ambil ID Peluang yang baru saja dibuat
            $id_peluang_baru = $conn->insert_id;

            // B. Cari Nama Toko Mitra
            $nama_toko = "Mitra Lafera"; 
            $q_mitra = $conn->query("SELECT nama_toko FROM mitra_profil WHERE id = '$id_mitra'");
            if ($q_mitra->num_rows > 0) {
                $dt_mitra = $q_mitra->fetch_assoc();
                $nama_toko = $dt_mitra['nama_toko'];
            }

            // C. Cari SEMUA Investor (Ambil ID dan FCM Token)
            $q_investor = $conn->query("SELECT id, fcm_token FROM users WHERE role = 'investor'");

            // D. Loop Insert Notifikasi & Kirim Push Notif
            if ($q_investor->num_rows > 0) {
                while($inv = $q_investor->fetch_assoc()) {
                    $id_user_investor = $inv['id'];
                    $token_hp         = $inv['fcm_token']; // Tangkap Token

                    $notif_judul = "Peluang Baru Rilis! 🔥";
                    $notif_pesan = "Toko $nama_toko baru saja membuka investasi: $judul. Cek prospektusnya sekarang!";
                    $tipe = "peluang_baru"; 

                    // 1. Simpan ke Database
                    $sql_notif = "INSERT INTO notifikasi (id_user, judul, pesan, tipe, related_id, is_read) 
                                  VALUES ('$id_user_investor', '$notif_judul', '$notif_pesan', '$tipe', '$id_peluang_baru', 0)";
                    $conn->query($sql_notif);

                    // 2. Kirim Push Notifikasi (FCM)
                    if (!empty($token_hp)) {
                        kirimNotifikasiFCM($token_hp, $notif_judul, $notif_pesan);
                    }
                }
            }
            // --- SELESAI LOGIKA NOTIFIKASI ---

            echo json_encode(["message" => "Berhasil ditambah"]);
        } else {
            echo json_encode(["message" => "Gagal: " . $conn->error]);
        }
        break;

    case 'PUT':
        parse_str(file_get_contents("php://input"), $_PUT);
        $id = $_PUT['id'];
        $judul = $_PUT['judul'];
        $deskripsi = $_PUT['deskripsi'];
        $target = $_PUT['target_dana'];
        $terkumpul = $_PUT['dana_terkumpul']; 
        $status = $_PUT['status'];

        $sql = "UPDATE peluang_investasi SET judul='$judul', deskripsi='$deskripsi', 
                target_dana='$target', dana_terkumpul='$terkumpul', status='$status' WHERE id=$id";
        
        if($conn->query($sql)) echo json_encode(["message" => "Berhasil diupdate"]);
        break;

    case 'DELETE':
        $id = $_GET['id'];

        $cek_file = "SELECT file_prospektus FROM peluang_investasi WHERE id=$id";
        $result_file = $conn->query($cek_file);
        
        if ($result_file->num_rows > 0) {
            $row = $result_file->fetch_assoc();
            $nama_file = $row['file_prospektus'];

            if (!empty($nama_file)) {
                $path_file = "uploads/" . $nama_file;
                if (file_exists($path_file)) {
                    unlink($path_file); 
                }
            }
        }

        $sql = "DELETE FROM peluang_investasi WHERE id=$id";
        if($conn->query($sql)) {
            echo json_encode(["message" => "Berhasil dihapus"]);
        } else {
            echo json_encode(["message" => "Gagal menghapus data"]);
        }
        break;
}
$conn->close();
?>