<?php
// lafera_api/permintaan_investasi.php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, GET, PUT, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

ini_set('display_errors', 0);
error_reporting(0);

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

include "konfigurasi/koneksi.php"; 
// 1. TAMBAHAN WAJIB: Panggil Helper FCM
include "konfigurasi/fcm_helper.php"; 

if (!$connect) {
    http_response_code(500);
    echo json_encode(["status" => "error", "message" => "Koneksi database gagal"]);
    exit();
}

$method = $_SERVER['REQUEST_METHOD'];

switch($method) {
    case 'POST':
        // --- INVESTOR MENGIRIM PERMINTAAN INVESTASI ---
        $inputJSON = file_get_contents('php://input');
        $input = json_decode($inputJSON, true);
        
        if (!isset($input['id_peluang']) || !isset($input['id_user']) || !isset($input['nominal'])) {
            http_response_code(400);
            echo json_encode(["status" => "error", "message" => "Data tidak lengkap"]);
            exit();
        }
        
        $id_peluang = mysqli_real_escape_string($connect, $input['id_peluang']);
        $id_user    = mysqli_real_escape_string($connect, $input['id_user']);
        $nominal    = mysqli_real_escape_string($connect, $input['nominal']);

        $checkUser = mysqli_query($connect, "SELECT id, nama_lengkap FROM users WHERE id = '$id_user'");
        if (mysqli_num_rows($checkUser) == 0) {
            echo json_encode(["status" => "error", "message" => "User tidak ditemukan"]);
            exit();
        }
        $dt_investor = mysqli_fetch_assoc($checkUser);
        $nama_investor = $dt_investor['nama_lengkap'];
        
        $sql = "INSERT INTO permintaan_investasi (id_peluang, id_user, nominal, status) 
                VALUES ('$id_peluang', '$id_user', '$nominal', 'Pending')";
        
        if(mysqli_query($connect, $sql)) {
            
            // --- LOGIKA NOTIFIKASI ---
            $q_proyek = mysqli_query($connect, "SELECT judul, id_mitra FROM peluang_investasi WHERE id = '$id_peluang'");
            if(mysqli_num_rows($q_proyek) > 0){
                $dt_proyek = mysqli_fetch_assoc($q_proyek);
                $id_mitra_pemilik = $dt_proyek['id_mitra']; 
                $judul_proyek = $dt_proyek['judul'];

                $notif_judul = "Dana Masuk!";
                $notif_pesan = "$nama_investor ingin berinvestasi Rp " . number_format($nominal) . " di proyek $judul_proyek. Segera validasi.";
                $tipe = "transaksi_masuk";

                // A. Simpan ke Database (Lonceng)
                mysqli_query($connect, "INSERT INTO notifikasi (id_user, judul, pesan, tipe, related_id, is_read) 
                                        VALUES ('$id_mitra_pemilik', '$notif_judul', '$notif_pesan', '$tipe', '$id_peluang', 0)");

                // B. KIRIM PUSH NOTIFIKASI (FCM) KE MITRA
                $q_token = mysqli_query($connect, "SELECT u.fcm_token FROM users u JOIN mitra_profil m ON u.id = m.id_user WHERE m.id = '$id_mitra_pemilik'");
                if ($row_token = mysqli_fetch_assoc($q_token)) {
                    $token_hp = $row_token['fcm_token'];
                    if (!empty($token_hp)) {
                        kirimNotifikasiFCM($token_hp, $notif_judul, $notif_pesan);
                    }
                }
            }
            // -------------------------

            echo json_encode(["status" => "success", "message" => "Berhasil disimpan"]);
        } else {
            echo json_encode(["status" => "error", "message" => mysqli_error($connect)]);
        }
        break;

    case 'GET':
        $id_mitra = isset($_GET['id_mitra']) ? mysqli_real_escape_string($connect, $_GET['id_mitra']) : '';
        $id_user  = isset($_GET['id_user']) ? mysqli_real_escape_string($connect, $_GET['id_user']) : ''; 

        // UPDATE: Menambahkan p.rekening_tujuan pada baris SELECT di bawah ini
        $sql = "SELECT p.*, o.judul as nama_proyek, u.nama_lengkap as nama_investor, o.id_mitra, u.id as id_user_investor, p.rekening_tujuan
                FROM permintaan_investasi p 
                JOIN peluang_investasi o ON p.id_peluang = o.id 
                JOIN users u ON p.id_user = u.id";

        $conditions = [];
        if (!empty($id_mitra)) {
             $conditions[] = "o.id_mitra = '$id_mitra'";
        }
        if (!empty($id_user)) {
             $conditions[] = "p.id_user = '$id_user'";
        }

        if (count($conditions) > 0) {
            $sql .= " WHERE " . implode(" AND ", $conditions);
        }

        $sql .= " ORDER BY p.tanggal DESC";
        $result = mysqli_query($connect, $sql);
        $data = array();
        if ($result) {
            while($row = mysqli_fetch_assoc($result)) {
                $row['url_bukti'] = !empty($row['bukti_pembayaran']) 
                    ? "https://laferacollective.web.id/lafera_api/uploads/pembayaran/" . $row['bukti_pembayaran'] 
                    : null;
                $data[] = $row;
            }
        }
        echo json_encode($data);
        break;

    case 'PUT':
        // --- MITRA MEMVALIDASI (TERIMA/TOLAK/INSTRUKSI BAYAR) ---
        $inputJSON = file_get_contents('php://input');
        $input = json_decode($inputJSON, true);

        if(isset($input['id']) && isset($input['status'])) {
            $id_permintaan = mysqli_real_escape_string($connect, $input['id']);
            $status_baru = mysqli_real_escape_string($connect, $input['status']);
            
            // Tangkap data rekening jika ada (untuk instruksi bayar)
            $rekening = isset($input['rekening_tujuan']) ? mysqli_real_escape_string($connect, $input['rekening_tujuan']) : '';

            // 1. Ambil Data Permintaan
            $cekData = mysqli_query($connect, "SELECT p.id_user, p.id_peluang, p.nominal, o.judul, o.id_mitra 
                                               FROM permintaan_investasi p
                                               JOIN peluang_investasi o ON p.id_peluang = o.id
                                               WHERE p.id = '$id_permintaan'");
            
            if(mysqli_num_rows($cekData) > 0){
                $dt_awal = mysqli_fetch_assoc($cekData);
                $id_investor = $dt_awal['id_user'];
                $id_proyek   = $dt_awal['id_peluang'];
                $judul_proyek= $dt_awal['judul'];
                $nominal_val = $dt_awal['nominal'];
                $id_mitra_pemilik = $dt_awal['id_mitra'];
            }

            // 2. Logika Update Dana Terkumpul
            if ($status_baru == 'Diterima') {
                mysqli_query($connect, "UPDATE peluang_investasi SET dana_terkumpul = dana_terkumpul + $nominal_val WHERE id = '$id_proyek'");
            }
            else if ($status_baru == 'Ditolak') {
                $cekStatusLama = mysqli_query($connect, "SELECT status FROM permintaan_investasi WHERE id = '$id_permintaan'");
                $st_lama = mysqli_fetch_assoc($cekStatusLama);
                if ($st_lama['status'] == 'Diterima') {
                     mysqli_query($connect, "UPDATE peluang_investasi SET dana_terkumpul = dana_terkumpul - $nominal_val WHERE id = '$id_proyek'");
                }
            }

            // 3. Update Status Permintaan (Termasuk kolom rekening jika sedang instruksi bayar)
            if (!empty($rekening)) {
                $sql = "UPDATE permintaan_investasi SET status = '$status_baru', rekening_tujuan = '$rekening' WHERE id = '$id_permintaan'";
            } else {
                $sql = "UPDATE permintaan_investasi SET status = '$status_baru' WHERE id = '$id_permintaan'";
            }
            
            if(mysqli_query($connect, $sql)) {
                
                // --- A. LOGIKA NOTIFIKASI ---
                if (isset($id_investor)) {
                    $notif_judul = ""; $notif_pesan = ""; $tipe_notif = "status_investasi";

                    if ($status_baru == 'Menunggu Pembayaran') {
                        $notif_judul = "Instruksi Pembayaran 💳";
                        $notif_pesan = "Permintaan Anda di $judul_proyek disetujui. Silakan transfer ke $rekening.";
                    } else if ($status_baru == 'Diterima') {
                        $notif_judul = "Investasi Diterima! 🎉";
                        $notif_pesan = "Selamat! Pembayaran Anda telah diverifikasi di $judul_proyek.";
                    } else if ($status_baru == 'Ditolak') {
                        $notif_judul = "Investasi Ditolak";
                        $notif_pesan = "Maaf, investasi Anda di $judul_proyek ditolak oleh Mitra.";
                    }
                    
                    if (!empty($notif_judul)) {
                        mysqli_query($connect, "INSERT INTO notifikasi (id_user, judul, pesan, tipe, related_id, is_read) 
                                                VALUES ('$id_investor', '$notif_judul', '$notif_pesan', '$tipe_notif', '$id_proyek', 0)");

                        $q_token = mysqli_query($connect, "SELECT fcm_token FROM users WHERE id = '$id_investor'");
                        if ($row_token = mysqli_fetch_assoc($q_token)) {
                            if (!empty($row_token['fcm_token'])) {
                                kirimNotifikasiFCM($row_token['fcm_token'], $notif_judul, $notif_pesan);
                            }
                        }
                    }
                }

                // --- B. LOGIKA BROADCAST JIKA TARGET TERPENUHI ---
                if ($status_baru == 'Diterima') {
                    $cekTarget = mysqli_query($connect, "SELECT target_dana, dana_terkumpul, judul FROM peluang_investasi WHERE id = '$id_proyek'");
                    if(mysqli_num_rows($cekTarget) > 0) {
                        $dt_tgt = mysqli_fetch_assoc($cekTarget);
                        if ($dt_tgt['dana_terkumpul'] >= $dt_tgt['target_dana']) {
                            
                            mysqli_query($connect, "UPDATE peluang_investasi SET status = 'Penuh' WHERE id = '$id_proyek'");

                            $judul_mitra = "Target Terpenuhi! 🎯";
                            $pesan_mitra = "Selamat! Dana untuk proyek $judul_proyek sudah mencapai 100%.";
                            mysqli_query($connect, "INSERT INTO notifikasi (id_user, judul, pesan, tipe, related_id, is_read) 
                                                    VALUES ('$id_mitra_pemilik', '$judul_mitra', '$pesan_mitra', 'target_penuh', '$id_proyek', 0)");
                            
                            $q_tok_mitra = mysqli_query($connect, "SELECT u.fcm_token FROM users u JOIN mitra_profil m ON u.id = m.id_user WHERE m.id = '$id_mitra_pemilik'");
                            if($r_tm = mysqli_fetch_assoc($q_tok_mitra)) {
                                if(!empty($r_tm['fcm_token'])) kirimNotifikasiFCM($r_tm['fcm_token'], $judul_mitra, $pesan_mitra);
                            }

                            $q_inv_all = mysqli_query($connect, "SELECT DISTINCT p.id_user, u.fcm_token FROM permintaan_investasi p
                                                                 JOIN users u ON p.id_user = u.id
                                                                 WHERE p.id_peluang = '$id_proyek' AND p.status = 'Diterima'");
                            
                            while($row_inv = mysqli_fetch_assoc($q_inv_all)) {
                                $id_user_inv = $row_inv['id_user'];
                                $token_inv   = $row_inv['fcm_token'];
                                $judul_inv = "Proyek Siap Jalan! 🚀";
                                $pesan_inv = "Target dana $judul_proyek telah terpenuhi. Proyek kini berjalan.";

                                mysqli_query($connect, "INSERT INTO notifikasi (id_user, judul, pesan, tipe, related_id, is_read) 
                                                        VALUES ('$id_user_inv', '$judul_inv', '$pesan_inv', 'target_penuh', '$id_proyek', 0)");
                                
                                if(!empty($token_inv)) kirimNotifikasiFCM($token_inv, $judul_inv, $pesan_inv);
                            }
                        }
                    }
                }

                echo json_encode(["status" => "success", "message" => "Status diperbarui"]);
            } else {
                echo json_encode(["status" => "error", "message" => mysqli_error($connect)]);
            }
        }
        break;

    default:
        http_response_code(405);
        echo json_encode(["status" => "error", "message" => "Method salah"]);
        break;
}
mysqli_close($connect);
?>