<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

ini_set('display_errors', 0);
error_reporting(0);

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once 'konfigurasi/koneksi.php';

if (!$connect) {
    echo json_encode(["status" => "error", "message" => "Koneksi database gagal"]);
    exit();
}

$inputJSON = file_get_contents('php://input');
$input = json_decode($inputJSON, true);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($input['id_user']) && isset($input['nama_lengkap'])) {
        $id_user = mysqli_real_escape_string($connect, $input['id_user']);
        $nama_lengkap = mysqli_real_escape_string($connect, $input['nama_lengkap']);
        $email = mysqli_real_escape_string($connect, $input['email']);
        $no_hp = mysqli_real_escape_string($connect, $input['no_hp']);
        $jenis_kelamin = mysqli_real_escape_string($connect, $input['jenis_kelamin']);
        
        // Cek apakah email sudah digunakan user lain
        $checkEmail = mysqli_query($connect, 
            "SELECT id FROM users WHERE email = '$email' AND id != '$id_user'"
        );
        
        if (mysqli_num_rows($checkEmail) > 0) {
            echo json_encode([
                "status" => "error",
                "message" => "Email sudah digunakan oleh user lain"
            ]);
            exit();
        }
        
        $query = "UPDATE users SET 
                  nama_lengkap = '$nama_lengkap',
                  email = '$email',
                  no_hp = '$no_hp',
                  jenis_kelamin = '$jenis_kelamin'
                  WHERE id = '$id_user'";
        
        if (mysqli_query($connect, $query)) {
            echo json_encode([
                "status" => "success",
                "message" => "Profil berhasil diperbarui"
            ]);
        } else {
            echo json_encode([
                "status" => "error",
                "message" => "Gagal memperbarui profil: " . mysqli_error($connect)
            ]);
        }
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Data tidak lengkap"
        ]);
    }
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Method tidak valid"
    ]);
}

mysqli_close($connect);
?>