<?php
// lafera_api/upload_bukti_pembayaran.php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

include "konfigurasi/koneksi.php";
include "konfigurasi/fcm_helper.php";

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Metode tidak diizinkan"]);
    exit();
}

// 1. TANGKAP DATA DARI FLUTTER
$id_permintaan = isset($_POST['id_permintaan']) ? mysqli_real_escape_string($connect, $_POST['id_permintaan']) : null;

if (empty($id_permintaan) || !isset($_FILES['file_bukti'])) {
    echo json_encode(["status" => "error", "message" => "Data tidak lengkap"]);
    exit();
}

// 2. KONFIGURASI FOLDER UPLOAD
$target_dir = "uploads/pembayaran/";
if (!is_dir($target_dir)) {
    mkdir($target_dir, 0777, true);
}

$file_name = $_FILES['file_bukti']['name'];
$file_tmp  = $_FILES['file_bukti']['tmp_name'];
$file_ext  = pathinfo($file_name, PATHINFO_EXTENSION);

// Buat nama file unik: BUKTI_IDPERMINTAAN_WAKTU.ext
$unique_name = "BUKTI_" . $id_permintaan . "_" . time() . "." . $file_ext;
$target_file = $target_dir . $unique_name;

// 3. PROSES UPLOAD DAN UPDATE DATABASE
if (move_uploaded_file($file_tmp, $target_file)) {
    
    // Update kolom bukti_pembayaran dan ubah status menjadi 'Menunggu Verifikasi'
    $sql = "UPDATE permintaan_investasi 
            SET bukti_pembayaran = '$unique_name', status = 'Menunggu Verifikasi' 
            WHERE id = '$id_permintaan'";

    if (mysqli_query($connect, $sql)) {
        
        // --- KIRIM NOTIFIKASI KE MITRA ---
        // Cari tahu siapa pemilik proyek ini
        $q_info = mysqli_query($connect, "SELECT o.id_mitra, o.judul, u.fcm_token, u.id as id_user_mitra
                                         FROM permintaan_investasi p 
                                         JOIN peluang_investasi o ON p.id_peluang = o.id 
                                         JOIN mitra_profil m ON o.id_mitra = m.id
                                         JOIN users u ON m.id_user = u.id
                                         WHERE p.id = '$id_permintaan'");
        
        if ($data = mysqli_fetch_assoc($q_info)) {
            $token_mitra = $data['fcm_token'];
            $id_user_mitra = $data['id_user_mitra'];
            $nama_proyek = $data['judul'];

            $judul_notif = "Bukti Transfer Masuk! 📄";
            $pesan_notif = "Seorang investor telah mengunggah bukti pembayaran untuk proyek $nama_proyek. Segera verifikasi.";

            // Simpan Notif ke DB Mitra
            mysqli_query($connect, "INSERT INTO notifikasi (id_user, judul, pesan, tipe, related_id) 
                                    VALUES ('$id_user_mitra', '$judul_notif', '$pesan_notif', 'verifikasi_pembayaran', '$id_permintaan')");
            
            // Kirim Push Notif
            if (!empty($token_mitra)) {
                kirimNotifikasiFCM($token_mitra, $judul_notif, $pesan_notif);
            }
        }

        echo json_encode(["status" => "success", "message" => "Bukti pembayaran berhasil diunggah"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Gagal memperbarui database"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Gagal mengunggah file ke server"]);
}

mysqli_close($connect);
?>