<?php
// lafera_api/upload_laporan.php

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST, OPTIONS");

// Matikan tampilan error agar tidak merusak JSON
ini_set('display_errors', 0);
error_reporting(0);

include 'konfigurasi/koneksi.php'; 
include 'konfigurasi/fcm_helper.php'; 

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    // 1. Validasi Input
    if (!isset($_POST['id_proyek']) || !isset($_FILES['file_laporan'])) {
        http_response_code(400);
        echo json_encode(["status" => "error", "message" => "Data tidak lengkap"]);
        exit;
    }

    $id_proyek = mysqli_real_escape_string($connect, $_POST['id_proyek']);
    $judul_laporan = isset($_POST['judul_laporan']) ? mysqli_real_escape_string($connect, $_POST['judul_laporan']) : "Laporan Keuangan";
    
    // 2. Folder Upload
    $target_dir = "uploads/laporan/";
    if (!is_dir($target_dir)) {
        mkdir($target_dir, 0777, true);
    }

    // 3. Proses Upload
    $file_extension = pathinfo($_FILES["file_laporan"]["name"], PATHINFO_EXTENSION);
    $new_file_name = "LAP_" . time() . "_" . $id_proyek . "." . $file_extension;
    $target_file = $target_dir . $new_file_name;

    if (move_uploaded_file($_FILES["file_laporan"]["tmp_name"], $target_file)) {
        
        // 4. Simpan ke Database
        $query = "INSERT INTO laporan_keuangan (id_proyek, judul_laporan, file_path) 
                  VALUES ('$id_proyek', '$judul_laporan', '$new_file_name')";
        
        if (mysqli_query($connect, $query)) {
            
            // --- MULAI BLOK NOTIFIKASI (KITA BUNGKUS DENGAN AMAN) ---
            // Kita gunakan try-catch logik sederhana agar kalau notif gagal, upload TETAP SUKSES.
            
            $q_proyek = mysqli_query($connect, "SELECT judul FROM peluang_investasi WHERE id = '$id_proyek'");
            
            if ($q_proyek && mysqli_num_rows($q_proyek) > 0) {
                $dt_proyek = mysqli_fetch_assoc($q_proyek);
                $nama_proyek = $dt_proyek['judul'];

                // Cari Investor
                $q_investor = mysqli_query($connect, "SELECT DISTINCT p.id_user, u.fcm_token 
                                                      FROM permintaan_investasi p
                                                      JOIN users u ON p.id_user = u.id
                                                      WHERE p.id_peluang = '$id_proyek' AND p.status = 'Diterima'");
                
                if ($q_investor) {
                    while ($row_inv = mysqli_fetch_assoc($q_investor)) {
                        $id_investor = $row_inv['id_user'];
                        $token_hp    = $row_inv['fcm_token'];
                        
                        $judul_notif = "Laporan Keuangan Baru 📊";
                        $pesan_notif = "Laporan untuk proyek $nama_proyek telah terbit.";
                        
                        // Insert Notif ke DB
                        mysqli_query($connect, "INSERT INTO notifikasi (id_user, judul, pesan, tipe, related_id, is_read) 
                                                VALUES ('$id_investor', '$judul_notif', '$pesan_notif', 'laporan', '$id_proyek', 0)");

                        // Kirim Push (Cek dulu tokennya)
                        if (!empty($token_hp)) {
                            // Suppress error dengan @ agar kalau gagal tidak bikin crash 500
                            @kirimNotifikasiFCM($token_hp, $judul_notif, $pesan_notif);
                        }
                    }
                }
            }
            // --- SELESAI BLOK NOTIFIKASI ---

            // PENTING: Response Sukses harus TETAP DIKIRIM apapun yang terjadi di notifikasi
            echo json_encode([
                "status" => "success", 
                "message" => "Berhasil disimpan"
            ]);

        } else {
            // Gagal Insert DB -> Hapus File
            if(file_exists($target_file)) unlink($target_file);
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "DB Error: " . mysqli_error($connect)]);
        }
    } else {
        http_response_code(500);
        echo json_encode(["status" => "error", "message" => "Gagal Upload File (Permission)"]);
    }
}
?>