<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

include "konfigurasi/koneksi.php";

// Penyesuaian variabel koneksi
if (!isset($connect) && isset($koneksi)) { $connect = $koneksi; }

$response = array();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    // 1. Validasi Input & Anti SQL Injection
    $id_proyek = isset($_POST['id_proyek']) ? mysqli_real_escape_string($connect, $_POST['id_proyek']) : '';
    $judul     = isset($_POST['judul']) ? mysqli_real_escape_string($connect, $_POST['judul']) : '';

    if (empty($id_proyek) || empty($judul)) {
        echo json_encode(['value' => 0, 'message' => 'ID Proyek dan Judul wajib diisi']);
        exit();
    }

    // 2. Cek File
    if (isset($_FILES['file']['name'])) {
        
        $target_dir = "uploads/";
        if (!is_dir($target_dir)) { mkdir($target_dir, 0777, true); } // Buat folder jika belum ada
        
        $fileName = basename($_FILES["file"]["name"]);
        $fileType = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
        
        // 3. KEAMANAN: Hanya izinkan tipe file tertentu
        $allowedTypes = array('jpg', 'png', 'jpeg', 'pdf', 'doc', 'docx');
        if (!in_array($fileType, $allowedTypes)) {
            echo json_encode(['value' => 0, 'message' => 'Format file tidak diizinkan (Hanya JPG, PNG, PDF, DOCX)']);
            exit();
        }

        // 4. KEAMANAN: Cek Ukuran File (Max 5MB)
        if ($_FILES["file"]["size"] > 5000000) {
            echo json_encode(['value' => 0, 'message' => 'Ukuran file terlalu besar (Max 5MB)']);
            exit();
        }
        
        // Buat nama file unik
        $new_name = "LEGALITAS_" . time() . "_" . $id_proyek . "." . $fileType;
        $target_file = $target_dir . $new_name;

        if (move_uploaded_file($_FILES["file"]["tmp_name"], $target_file)) {
            
            // Simpan ke database
            $sql = "INSERT INTO legalitas (id_proyek, judul, file_path) VALUES ('$id_proyek', '$judul', '$new_name')";
            
            if ($connect->query($sql) === TRUE) {
                $response['value'] = 1;
                $response['message'] = "Berhasil upload dokumen legalitas";
            } else {
                $response['value'] = 0;
                $response['message'] = "Gagal menyimpan ke database";
            }
        } else {
            $response['value'] = 0;
            $response['message'] = "Gagal upload file ke server";
        }
    } else {
        $response['value'] = 0;
        $response['message'] = "File tidak ditemukan";
    }
} else {
    $response['value'] = 0;
    $response['message'] = "Metode request harus POST";
}

echo json_encode($response);
$connect->close();
?>