<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include "konfigurasi/koneksi.php";

// Pastikan request menggunakan metode POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Metode tidak diizinkan"]);
    exit();
}

// Menangkap id_user dan deskripsi dari Flutter
$id_user = isset($_POST['id_user']) ? mysqli_real_escape_string($connect, $_POST['id_user']) : null;
$description = isset($_POST['description']) ? mysqli_real_escape_string($connect, $_POST['description']) : "Portofolio Investor";

// Validasi ID User
if (empty($id_user)) {
    echo json_encode(["status" => "error", "message" => "ID User tidak ditemukan"]);
    exit();
}

// Logika Upload File
if (isset($_FILES['file_portofolio'])) {
    $file_tmp = $_FILES['file_portofolio']['tmp_name'];
    $file_name = $_FILES['file_portofolio']['name'];
    $file_size = $_FILES['file_portofolio']['size'];
    $file_type = pathinfo($file_name, PATHINFO_EXTENSION);
    
    // Memberikan nama unik pada file untuk menghindari duplikasi
    $unique_file_name = time() . "_" . $file_name;
    $upload_path = "uploads/" . $unique_file_name;

    // Batasan ukuran file (misal 5MB)
    if ($file_size > 5000000) {
        echo json_encode(["status" => "error", "message" => "Ukuran file terlalu besar (Maks 5MB)"]);
        exit();
    }

    // Proses pindahkan file dari folder temp ke folder uploads
    if (move_uploaded_file($file_tmp, $upload_path)) {
        
        // Simpan metadata ke tabel portfolio
        $sql = "INSERT INTO portfolio (id_user, file_name, file_path, file_type, description) 
                VALUES ('$id_user', '$file_name', '$upload_path', '$file_type', '$description')";

        if (mysqli_query($connect, $sql)) {
            echo json_encode([
                "status" => "success", 
                "message" => "Portofolio berhasil diunggah",
                "data" => ["file_name" => $file_name]
            ]);
        } else {
            echo json_encode(["status" => "error", "message" => "Gagal menyimpan data ke database: " . mysqli_error($connect)]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "Gagal memindahkan file ke server"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Tidak ada file yang dipilih"]);
}

mysqli_close($connect);
?>