<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

include "konfigurasi/koneksi.php";

// Pastikan metode request adalah POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Metode tidak diizinkan"]);
    exit();
}

// Menangkap id_peluang dari Flutter
$id_peluang = isset($_POST['id_peluang']) ? mysqli_real_escape_string($connect, $_POST['id_peluang']) : null;

if (empty($id_peluang)) {
    echo json_encode(["status" => "error", "message" => "ID Peluang tidak ditemukan"]);
    exit();
}

// Logika Upload File
if (isset($_FILES['file_prospektus'])) {
    $file_tmp = $_FILES['file_prospektus']['tmp_name'];
    $file_name = $_FILES['file_prospektus']['name'];
    $file_size = $_FILES['file_prospektus']['size'];
    $file_ext = pathinfo($file_name, PATHINFO_EXTENSION);
    
    // Memberikan nama unik agar tidak tertimpa: prospektus_ID_WAKTU.ext
    $unique_file_name = "prospektus_" . $id_peluang . "_" . time() . "." . $file_ext;
    $upload_path = "uploads/" . $unique_file_name;

    // Batasan ukuran file 5MB
    if ($file_size > 5000000) {
        echo json_encode(["status" => "error", "message" => "Ukuran file terlalu besar (Maks 5MB)"]);
        exit();
    }

    // Proses upload
    if (move_uploaded_file($file_tmp, $upload_path)) {
        
        // Update kolom file_prospektus pada tabel peluang_investasi
        $sql = "UPDATE peluang_investasi SET file_prospektus = '$unique_file_name' WHERE id = '$id_peluang'";

        if (mysqli_query($connect, $sql)) {
            echo json_encode([
                "status" => "success", 
                "message" => "Prospektus berhasil diperbarui",
                "file" => $unique_file_name
            ]);
        } else {
            echo json_encode(["status" => "error", "message" => "Gagal update database: " . mysqli_error($connect)]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "Gagal menyimpan file di server"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "File tidak ditemukan"]);
}

mysqli_close($connect);
?>